<?php
global $wpdb;
set_time_limit(600);

$_data = $_FILES['file'];
if ( !$_data )
{
    echo json_encode( array(
        'error'     => true,
        'message'   => 'No DATA received'
    ) );
    die();
}


function get_extension($file) 
{
    $extension = end(explode(".", $file));
    return $extension ? $extension : false;
}

if ( isset( $_data['name'] ) ) 
{


    if ( !empty( $_data['name'] ) )
    {

        $extension       = get_extension( $_data['name'] );

        if ( !$extension || $extension != "wpsbc" )
        {
            echo json_encode( array(
                'error'     => true,
                'message'   => __('Unsuported file extension! This is not our export file!')
            ) );
            die();
        }
        else
        {

            delete_option('wpsbc-update-total');
            delete_option('wpsbc-update-progress');

            $total      = 0;
            $progress   = 0;

            add_option('wpsbc-update-total',     $total);
            add_option('wpsbc-update-progress',  $progress);

            /**
             *
             * Everything looks good, we can proceed with the import
             *
             */


            $content            = file_get_contents( $_data['tmp_name'] );
            $content            = json_decode( $content );

            $tables             = array(
                'calendars'     => $wpdb->prefix . 'sbc_calendars'
            );

            foreach ( $tables as $table )
            {
                $sql = "DROP TABLE IF EXISTS ". $table;
                $wpdb->query($sql);
            }


            $sql = "CREATE TABLE `".$wpdb->prefix."sbc_calendars` (
              `calendarID` int(10) NOT NULL AUTO_INCREMENT,
              `calendarTitle` text,
              `createdDate` int(11) DEFAULT NULL,
              `modifiedDate` int(11) DEFAULT NULL,
              `calendarData` text,
              `calendarLegend` text,
              `calendarUsers` text,
              `calendarHash` varchar(32),
            UNIQUE KEY (`calendarID`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='WP Simple Booking Calendar';"; 
                
            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
            dbDelta( $sql, true );



            $options                = (array) $content->options;
            
            // Adding options
            update_option( "wpsbc_db_version", $options['wpsbc_db_version'] );
            update_option( "wpsbc-languages", $options['wpsbc-languages'], '' );
            update_option( "wpsbc-options", $options['wpsbc-options'], '' );
            update_option( "wpsbc-default-legend", $options['wpsbc-default-legend'] );

            


            unset($content->options);



            $wpsbcDB             = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

            if ($wpsbcDB->connect_errno) 
            {
                echo json_encode( array(
                    'error'     => true,
                    'message'   => __('Sorry, this website is experiencing problems.')
                ) );
                die;
            }

            $total = $total + count( $content->calendars );

            update_option('wpsbc-update-total', $total);
            


            foreach ( $content->calendars as $calendar )
            {
                // Creating the queries
                $calendarQuery = "INSERT INTO " 
                    . $wpdb->prefix
                    ."sbc_calendars (`calendarID`, `calendarTitle`, `createdDate`, `modifiedDate`, `calendarData`, `calendarLegend`, `calendarUsers`, `calendarHash`) VALUES ("
                    . $calendar->calendarID . ", "
                    . "'" . $calendar->calendarTitle . "', "
                    . $calendar->createdDate . ", "
                    . $calendar->modifiedDate . ", "
                    . "'" . $calendar->calendarData . "', "
                    . "'" . $calendar->calendarLegend . "', "
                    . "'" . $calendar->calendarUsers . "', "
                    . "'" . $calendar->calendarHash . "'"
                    . ");";

                if ( !$calendarResults = $wpsbcDB->query($calendarQuery) )
                {
                    echo json_encode( array(
                        'error'     => true,
                        'message'   => __('Query failed to execute for table "calendars"!')
                    ) );
                    die;
                }

                $progress++;
                update_option('wpsbc-update-progress', ($progress / $total ) * 100 );
            }

            $time_elapsed = microtime(true) - $start;

            if ( $wpdb->last_error == '' )
            {
                echo json_encode( array(
                    'error'     => false,
                    'message'   => __('Import was succesfull!')
                ) );


            }
            else
            {
                echo json_encode( array(
                    'error'     => true,
                    'message'   => '<p>' . __('Import error: ') . $wpdb->last_error . '</p>'
                ) );
            }


            // delete_option('wpsbc-update-total');
            // delete_option('wpsbc-update-progress');
            
            die; 
            
        }
    }
    else
    {
        echo json_encode( array(
            'error'     => true,
            'message'   => __('<p>You have to add the <strong>backup/exported</strong> file first then hit <strong>Import</strong></p>')
        ) );
        die;
    }
}