<?php
add_action('media_buttons', 'wpsbc_add_form_button', 20);
function wpsbc_add_form_button(){
    $is_post_edit_page = in_array(basename($_SERVER['PHP_SELF']), array('post.php', 'page.php', 'page-new.php', 'post-new.php'));
    if(!$is_post_edit_page)
        return;

    // do a version check for the new 3.5 UI
    $version = get_bloginfo('version');

    if ($version < 3.5) {
        // show button for v 3.4 and below
        $image_btn =  WPSBC_PATH.'/images/date-button.gif';
        echo '<a href="#TB_inline?width=480&inlineId=wpsbc_add_calendar" class="thickbox" id="add_wpsbc" title=""><img src="'.$image_btn.'" alt="' . __("Add Calendar", 'wpsbc') . '" /></a>';
    } else {
        // display button matching new UI
        echo '<style>.wpsbc_media_icon{
                background:url('.WPSBC_PATH.'/images/date-button.gif) no-repeat top left;
                display: inline-block;
                height: 16px;
                margin: 0 2px 0 0;
                vertical-align: text-top;
                width: 16px;
                }
                .wp-core-ui a.wpsbc_media_link{
                 padding-left: 0.4em;
                }
                
                body #TB_window {width:800px !important; margin-left:-400px !important; max-width: 100% !important; max-height: 100% !important;}
                body #TB_ajaxContent {width: 940px !important; height: 580px !important; max-width: 100% !important; }                
             </style>
              <a href="#TB_inline?width=640&height=650&inlineId=wpsbc_add_calendar" class="thickbox button wpsbc_media_link" id="add_wpsbc" title="' . __("Add Calendar", 'wpsbc') . '"><span class="wpsbc_media_icon "></span> ' . __("Add Calendar", "wpsbc") . '</a>';
    }
}

add_action('admin_footer',  'wpsbc_add_mce_popup');    
function wpsbc_add_mce_popup(){
    global $wpdb;
    ?>
    <script>
        function wpsbc_insert_shortcode(){
            var calendar_id = jQuery("#wpsbc_calendar_id").val();
            if(calendar_id == ""){
                alert("<?php _e("Please select a form", "wpsbc") ?>");
                return;
            }

            var wpsbc_calendar_title = jQuery("#wpsbc_calendar_title").val();
            var wpsbc_calendar_legend = jQuery("#wpsbc_calendar_legend").val();
            var wpsbc_calendar_dropdown = jQuery("#wpsbc_calendar_dropdown").val();
            var wpsbc_calendar_start = jQuery("#wpsbc_calendar_start").val();
            var wpsbc_calendar_display = jQuery("#wpsbc_calendar_display").val();
            var wpsbc_calendar_language = jQuery("#wpsbc_calendar_language").val();
            var wpsbc_calendar_start_month = jQuery("#wpsbc_calendar_start_month").val();
            var wpsbc_calendar_start_year = jQuery("#wpsbc_calendar_start_year").val();
            var wpsbc_calendar_history = jQuery("#wpsbc_calendar_history").val();
            var wpsbc_calendar_tooltip = jQuery("#wpsbc_calendar_tooltip").val();
            var wpsbc_calendar_week_numbers = jQuery("#wpsbc_calendar_week_numbers").val();
            
            

            window.send_to_editor('[wpsbc id="' + calendar_id + '" title="' + wpsbc_calendar_title + '" legend="' + wpsbc_calendar_legend + '" dropdown="' + wpsbc_calendar_dropdown + '" start="' + wpsbc_calendar_start + '" display="' + wpsbc_calendar_display + '" language="' + wpsbc_calendar_language + '"  month="' + wpsbc_calendar_start_month + '" year="' + wpsbc_calendar_start_year + '" history="' + wpsbc_calendar_history + '" tooltip="' + wpsbc_calendar_tooltip + '" weeknumbers="' + wpsbc_calendar_week_numbers + '"]');
        }
    </script>

    <div id="wpsbc_add_calendar" style="display:none;">
        <div class="wrap wpsbc-shortcode-button-wrap">
            <div>
                <div style="padding:15px 15px 0 15px;">
                    <h3 style="color:#5A5A5A!important; font-family:Georgia,Times New Roman,Times,serif!important; font-size:1.8em!important; font-weight:normal!important;"><?php _e("Insert A Calendar", "wpsbc"); ?></h3>
                    <span>
                        <?php _e("Select a calendar below to add it to your post or page.", "wpsbc"); ?>
                    </span>
                </div>
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php _e("Calendar", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_id" style="width: 160px;">                
                        <?php $sql = 'SELECT * FROM ' . $wpdb->prefix . 'sbc_calendars';?>
                        <?php $rows = $wpdb->get_results( $sql, ARRAY_A );?>                         
                        <?php foreach($rows as $calendar):?>
                            <option value="<?php echo absint($calendar['calendarID']) ?>"><?php echo esc_html($calendar['calendarTitle']) ?></option>
                        <?php endforeach; ?>
                    </select> <br/>
                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php _e("Display title?", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_title" style="width: 160px;">
                        <option value="yes"><?php _e("Yes", "wpsbc"); ?></option>
                        <option value="no"><?php _e("No", "wpsbc"); ?></option>                        
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php _e("Display legend?", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_legend" style="width: 160px;">
                        <option value="yes"><?php _e("Yes", "wpsbc"); ?></option>
                        <option value="no"><?php _e("No", "wpsbc"); ?></option>                        
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; clear:left;  ">
                    <strong><?php _e("Display dropdown?", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_dropdown" style="width: 160px;">
                        <option value="yes"><?php _e("Yes", "wpsbc"); ?></option>
                        <option value="no"><?php _e("No", "wpsbc"); ?></option>                        
                    </select> <br/>                    
                </div>
                
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px;">
                    <strong><?php _e("Week starts on", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_start" style="width: 160px;">
                        <option value="1"><?php _e("Monday", "wpsbc"); ?></option>
                        <option value="2"><?php _e("Tuesday", "wpsbc"); ?></option>
                        <option value="3"><?php _e("Wednesday", "wpsbc"); ?></option>
                        <option value="4"><?php _e("Thursday", "wpsbc"); ?></option>
                        <option value="5"><?php _e("Friday", "wpsbc"); ?></option>
                        <option value="6"><?php _e("Saturday", "wpsbc"); ?></option>
                        <option value="7"><?php _e("Sunday", "wpsbc"); ?></option>
                        
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php _e("Months to display?", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_display" style="width: 160px;">
                        <?php for($i=1;$i<=12;$i++):?>
                            <option value="<?php echo $i;?>"><?php echo $i;?></option>
                        <?php endfor;?>                        
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px;  clear:left;">
                    <strong><?php _e("Language", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_language" style="width: 160px;">
                        <?php $activeLanguages = json_decode(get_option('wpsbc-languages'),true);?>
                            <option value="auto"><?php _e("Auto (let WP choose)", "wpsbc"); ?></option>
                        <?php foreach($activeLanguages as $code => $language):?>
                            <option value="<?php echo $code;?>"><?php echo $language;?></option>
                        <?php endforeach;?>                   
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php _e("Start Month", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_start_month" style="width: 160px;">
                        <option value="0"><?php _e("Current Month", "wpsbc"); ?></option>
                        <option value="1"><?php _e("January", "wpsbc"); ?></option>
                        <option value="2"><?php _e("February", "wpsbc"); ?></option>
                        <option value="3"><?php _e("March", "wpsbc"); ?></option>
                        <option value="4"><?php _e("April", "wpsbc"); ?></option>
                        <option value="5"><?php _e("May", "wpsbc"); ?></option>
                        <option value="6"><?php _e("June", "wpsbc"); ?></option>
                        <option value="7"><?php _e("July", "wpsbc"); ?></option>
                        <option value="8"><?php _e("August", "wpsbc"); ?></option>
                        <option value="9"><?php _e("September", "wpsbc"); ?></option>
                        <option value="10"><?php _e("October", "wpsbc"); ?></option>
                        <option value="11"><?php _e("November", "wpsbc"); ?></option>
                        <option value="12"><?php _e("December", "wpsbc"); ?></option>   
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php _e("Start Year", "wpsbc"); ?></strong><br />
                    <select id="wpsbc_calendar_start_year" style="width: 160px;">
                        <option value="0"><?php _e("Current Year", "wpsbc"); ?></option>
                        <?php for($i = date("Y"); $i<= date("Y") + 10; $i++):?>
                            <option value="<?php echo $i;?>"><?php echo $i;?></option>
                        <?php endfor;?>                 
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php echo __('Show history?','wpsbc');?></strong><br />
                    <select id="wpsbc_calendar_history" style="width: 160px;">
                        <option value="1"><?php echo __('Display booking history','wpsbc');?></option>
                        <option value="2"><?php echo __('Replace booking history with the default legend item','wpsbc');?></option>
                        <option value="3"><?php echo __('Use the Booking History Color from the Settings','wpsbc');?></option>                        
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php echo __('Show tooltip?','wpsbc');?></strong><br />
                    <select id="wpsbc_calendar_tooltip" style="width: 160px;">
                        <option selected="selected" value="1"><?php _e("No", "wpsbc"); ?></option>
                        <option value="2"><?php _e("Yes", "wpsbc"); ?></option>
                        <option value="3"><?php _e("Yes, with red indicator", "wpsbc"); ?></option>                      
                    </select> <br/>                    
                </div>
                
                <div style="padding:15px 15px 0 15px; float:left; width:160px; ">
                    <strong><?php echo __('Show week numbers?');?></strong><br />
                    <select id="wpsbc_calendar_week_numbers" style="width: 160px;">
                        <option value="yes"><?php _e("Yes", "wpsbc"); ?></option>
                        <option selected="selected" value="no"><?php _e("No", "wpsbc"); ?></option>                        
                    </select> <br/>                    
                </div>
                
               
                <div style="clear:left; padding:15px;">
                    <input type="button" class="button-primary" value="<?php _e("Insert Calendar", "wpsbc"); ?>" onclick="wpsbc_insert_shortcode();"/>&nbsp;&nbsp;&nbsp;
                <a class="button"  href="#" onclick="tb_remove(); return false;"><?php _e("Cancel", "wpsbc"); ?></a>
                </div>
            </div>
        </div>
    </div>

    <?php
}