<?php
/**
 * This function prepares the calendar
 */
function wpsbc_calendar($options = array()){
    
    $default_options = array('ajaxCall' => false, 'monthToShow' => null, 'yearToShow' => null, 'currentCalendar' => 1, 'totalCalendars' => 1 , 'firstDayOfWeek' => 1, 'showDropdown' => 1, 'calendarLanguage' => 'en', 'calendarData' => null, 'currentTimestamp' => mktime(0, 0, 0, date('n') , 15, date('Y')),'calendarLegend' => false, 'calendarID' => false, 'showDateEditor' => false, 'showLegend' => false, 'calendarHistory' => 1, 'showTooltip' => 1, 'showWeekNumbers' => false);
   
    
    foreach($default_options as $key => $value){
        if(empty($$key))
            $$key = $value;
    }
    
    extract($options);
    
    $output = '';

    
    if($ajaxCall == false):    
        $output .= '<div class="wpsbc-container wpsbc-calendar-'.$calendarID.'">';
        $output .= '<div class="wpsbc-calendars">';
    endif;
    
    if($showDateEditor == true){
        $output .= '<div class="wpsbc-responsive-calendars">';
        
        
        
    }
          
    for($i=0;$i<$totalCalendars;$i++):
        $calendarTimestamp = mktime(0, 0, 0, date('n',$currentTimestamp) + $i, 1, date('Y',$currentTimestamp));    
        $displayMonth = date('n', $calendarTimestamp);
        $displayYear = date('Y', $calendarTimestamp);
        $output .= wpsbc_showCalendar(array('monthToShow' => $displayMonth, 'yearToShow' => $displayYear, 'currentCalendar' => $i + 1, 'totalCalendars' => $totalCalendars , 'firstDayOfWeek' => ($firstDayOfWeek == 7) ? 0 : $firstDayOfWeek, 'calendarLanguage' => ($showDateEditor) ? substr(get_locale(),0,2) : $calendarLanguage, 'showDropdown' => $showDropdown, 'calendarData' => $calendarData, 'calendarID' => $calendarID, 'calendarHistory' => $calendarHistory, 'showTooltip' => $showTooltip, 'showWeekNumbers' => $showWeekNumbers));
    endfor;
    
    if($showDateEditor == true){
        
        $output .= wpsbc_edit_legend($calendarLegend, true, $calendarID);
        $output .= wpsbc_batch_update($calendarLegend);
        $output .= wpsbc_edit_users($calendarID);
    } 
    
    if($showLegend == 'yes'){
        $output .= '<div class="wpsbc-legend">';
            $output .= wpsbc_print_legend($calendarLegend,$calendarLanguage);  
        $output .= '<div class="wpsbc-clear"><!-- --></div></div>';
    }    
    
    if($showDateEditor == true){
        $output .= '</div>';
        
        $output .= '<div class="wpsbc-dates-editor-wrap">' . wpsbc_edit_dates( array( 'calendarData' => $calendarData, 'calendarLegend' => $calendarLegend, 'currentTimestamp' => $currentTimestamp, 'calendarLanguage' => ($showDateEditor) ? wpsbc_get_language() : $calendarLanguage ) ) . '</div>';
        
    }
    
    $output .= "<div class='wpsbc-clear'></div>";
        

    if($showDateEditor == false && $showTooltip == 1){
        $calendarData = json_decode($calendarData,true);
        if(!empty($calendarData) && is_array($calendarData)) foreach($calendarData as $year => $months){
            if(!empty($months) && is_array($months)) foreach($months as $month => $days){
                if(!empty($days) && is_array($days)) foreach($days as $day => $status){
                    if (strpos($day,'description') !== false) {
                        unset( $calendarData[$year][$month][$day] );
                    }
                }
            }
        }
        $calendarData = json_encode($calendarData);
    }
    
    
    $output .= '<div class="wpsbc-calendar-options">';
    $output .= '<div class="wpsbc-show-legend" data-show-legend="'.$showLegend.'">'; if($showDateEditor) $output .= $showLegend;
    $output .= '</div><div class="wpsbc-current-timestamp" data-current-timestamp="'.$currentTimestamp.'">'; if($showDateEditor) $output .= $currentTimestamp;
    $output .= '</div><div class="wpsbc-total-calendars" data-total-calendars="'.$totalCalendars.'">'; if($showDateEditor) $output .= $totalCalendars;
    $output .= "</div><div class='wpsbc-calendar-data' data-calendar-data='" . html_entity_decode(esc_html($calendarData)) . "'>"; if($showDateEditor) $output .= html_entity_decode(esc_html($calendarData));
    $output .= "</div><div class='wpsbc-calendar-legend' data-calendar-legend='" . html_entity_decode(esc_html($calendarLegend)) . "'>"; if($showDateEditor) $output .= html_entity_decode(esc_html($calendarLegend));
    $output .= '</div><div class="wpsbc-calendar-language" data-calendar-language="'.$calendarLanguage.'">'; if($showDateEditor) $output .= $calendarLanguage;
    $output .= '</div><div class="wpsbc-calendar-history" data-calendar-history="'.$calendarHistory.'">'; if($showDateEditor) $output .= $calendarHistory;
    $output .= '</div><div class="wpsbc-calendar-tooltip" data-calendar-tooltip="'.$showTooltip.'">'; if($showDateEditor) $output .= $showTooltip;
    $output .= '</div><div class="wpsbc-calendar-weeknumbers" data-calendar-weeknumbers="'.$showWeekNumbers.'">'; if($showDateEditor) $output .= $showWeekNumbers;
    $output .= '</div><div class="wpsbc-calendar-week-start" data-calendar-week-start="'.$firstDayOfWeek.'">'; if($showDateEditor) $output .= $firstDayOfWeek;
    $output .= '</div><div class="wpsbc-show-dropdown" data-show-dropdown="'.$showDropdown.'">'; if($showDateEditor) $output .= $showDropdown;
    $output .= '</div><div class="wpsbc-calendar-ID" data-calendar-ID="'.$calendarID.'">'; if($showDateEditor) $output .= $calendarID;
    $output .= '</div>';
    $output .= '</div>';
    
     
    
    
    if($ajaxCall == false): 
        
        $output .= '</div>';
        
        $output .= '</div><div class="wpsbc-clear"></div>';
        
    endif;
    
    return $output;
}
/**
 * This function is displays the calendar with the parameters given from the previous function
 */
function wpsbc_showCalendar($options = array())
{   
    
    
    foreach($options as $key => $value){
            $$key = $value;
    }
    
    $calendarData = json_decode($calendarData,true);
    if (($monthToShow === null) or ($yearToShow === null)) {
        $today = getdate();
        $monthToShow = $today['mon'];
        $yearToShow = $today['year'];
    } else {
        $today = getdate(mktime(0, 0, 0, $monthToShow, 1, $yearToShow));
    }

    // get first and last days of the month
    $firstDay = getdate(mktime(0, 0, 0, $monthToShow, 1, $yearToShow));
    $lastDay = getdate(mktime(0, 0, 0, $monthToShow + 1, 0, $yearToShow)); //trick! day = 0

    // Create a table with the necessary header information
    $output = '<div class="wpsbc-calendar';
    if($showWeekNumbers == 'yes'){
        $output .= ' wpsbc-week-numbers';
    }  
    
    $output .= '">';
    $output .= '<div class="wpsbc-heading">';
    if($currentCalendar == 1){
        $output .= '<a href="#" class="wpsbc-prev" title="'.__('Previous Month').'"></a>';
        if($showDropdown == true){
            $output .= '<div class="wpsbc-select-container"><select class="wpsbc-dropdown">';
                
                for($d=0;$d<12;$d++){
                    $output .= '<option value="' . mktime(0, 0, 0, $monthToShow + $d, 15, $yearToShow) . '">' . wpsbcMonth(date('F',mktime(0, 0, 0, $monthToShow + $d, 15, $yearToShow)), $calendarLanguage) . " " . date('Y',mktime(0, 0, 0, $monthToShow + $d, 15, $yearToShow)) . '</option>';
                }
            $output .= '</select></div>';
        } else {
            $output .= "<span>" . wpsbcMonth($today['month'],$calendarLanguage) . " " . $today['year'] . "</span>";    
        }
    } else {
        $output .= "<span>" . wpsbcMonth($today['month'],$calendarLanguage) . " " . $today['year'] . "</span>";    
    }        
    
    if($currentCalendar == $totalCalendars)
        $output .= '<a href="#" class="wpsbc-next" title="'.__('Next Month').'"></a>';
    $output .= "</div>";

    $output .= '<ul class="wpsbc-weekdays">';
    if($showWeekNumbers == 'yes'){
        $output .= '<li class="wpsbc-week-number"></li>';
    }
    
    $actday = 0; // used to count and represent each day
    
    $dayText = wpsbcDoW($calendarLanguage);
    for ($i = 0; $i < 7; $i++) { // put 7 days in header, starting at appropriate day ($firstDayOfWeek)
        $output .= '<li>' . $dayText[$firstDayOfWeek + $i] . '</li>';
    }
    $output .= '</ul>';
    
    $output .= '<ul>';
    if($showWeekNumbers == 'yes'){
        $output .= '<li class="wpsbc-week-number" title="'.__('Week').' '.date('W',mktime(0,0,0,$monthToShow,$actday+1,$yearToShow)).'">'.date('W',mktime(0,0,0,$monthToShow,1,$yearToShow)).'</li>';
    }
    
    
    // Display the first calendar row with correct start of week
    if ($firstDayOfWeek <= $firstDay['wday']) {
        $blanks = $firstDay['wday'] - $firstDayOfWeek;
    } else {
        $blanks = $firstDay['wday'] - $firstDayOfWeek + 7;
    }
    for ($i = 1; $i <= $blanks; $i++) {
        $output .= '<li class="wpsbc-pad"><!-- --></li>';
    }
    
    // Note: loop below starts using the residual value of $i from loop above
    for ( /* use value of $i resulting from last loop*/; $i <= 7; $i++) {
        
        if(!empty($calendarData[$yearToShow][$monthToShow][++$actday]))
            $status = $calendarData[$yearToShow][$monthToShow][$actday];
        else 
            $status = 'default';
            
        
        
        $dataTimestamp = mktime(0,0,0,$monthToShow,$actday,$yearToShow);        
        //handle past dates & tooltips
        $tooltip = false;    
        if($dataTimestamp + (60*60*24) < time()  && $calendarHistory != 1){
            if($calendarHistory == 2) $status = 'default'; //show default
            if($calendarHistory == 3) $status = 'wpsbc-grey-out-history'; //grey-out
        } else {
            if(!empty($calendarData[$yearToShow][$monthToShow]['description-' . $actday]) && in_array($showTooltip,array(2,3)))
                $tooltip = ' data-tooltip="'.htmlentities(wpsbc_replaceCustom($calendarData[$yearToShow][$monthToShow]['description-' . $actday])).'" data-tooltip-date="'.wpsbc_timeFormat($dataTimestamp).'"';
        }
        $today = ($dataTimestamp == mktime(0,0,0,date('n',current_time('timestamp')),date('j',current_time('timestamp')),date('Y',current_time('timestamp')))) ? ' wpsbc-today' : ''; 
        
        
        $output .= '<li'.$tooltip.' class="wpsbc-day'.$today.' wpsbc-day-'.$actday.' status-' . $status .  ' ">';
        
        if($tooltip && $showTooltip == 3) {$output .= '<span class="wpsbc-tooltip-corner"></span>';}
        
        $output .= '<span class="wpsbc-day-split-top wpsbc-day-split-top-'.$status.'"></span>';
        $output .= '<span class="wpsbc-day-split-bottom wpsbc-day-split-bottom-'.$status.'"></span>';    
        $output .= '<span class="wpsbc-day-split-day">'.$actday.'</span></li>';    
    
        
        
    }
    $output .= '</ul>';

    // Get how many complete weeks are in the actual month
    $fullWeeks = floor(($lastDay['mday'] - $actday) / 7);
    for ($i = 0; $i < $fullWeeks; $i++) {
        $output .= '<ul>';
        if($showWeekNumbers == 'yes'){
            $output .= '<li class="wpsbc-week-number" title="'.__('Week').' '.date('W',mktime(0,0,0,$monthToShow,$actday+1,$yearToShow)).'">'.date('W',mktime(0,0,0,$monthToShow,$actday+1,$yearToShow)).'</li>';
        }
        
        for ($j = 0; $j < 7; $j++) {
            if(!empty($calendarData[$yearToShow][$monthToShow][++$actday]))
                $status = $calendarData[$yearToShow][$monthToShow][$actday];
            else 
                $status = 'default';
            
            $dataTimestamp = mktime(0,0,0,$monthToShow,$actday,$yearToShow);        
            //handle past dates & tooltips
            $tooltip = false;    
            if($dataTimestamp + (60*60*24) < time()  && $calendarHistory != 1){
                if($calendarHistory == 2) $status = 'default'; //show default
                if($calendarHistory == 3) $status = 'wpsbc-grey-out-history'; //grey-out
            } else {
                if(!empty($calendarData[$yearToShow][$monthToShow]['description-' . $actday]) && in_array($showTooltip,array(2,3)))
                $tooltip = ' data-tooltip="'.htmlentities(wpsbc_replaceCustom($calendarData[$yearToShow][$monthToShow]['description-' . $actday])).'" data-tooltip-date="'.wpsbc_timeFormat($dataTimestamp).'"';
            }
            $today = ($dataTimestamp == mktime(0,0,0,date('n',current_time('timestamp')),date('j',current_time('timestamp')),date('Y',current_time('timestamp')))) ? ' wpsbc-today' : ''; 
            
            $output .= '<li'.$tooltip.' class="wpsbc-day'.$today.' wpsbc-day-'.$actday.' status-' . $status .  ' ">';
            
            if($tooltip && $showTooltip == 3) {$output .= '<span class="wpsbc-tooltip-corner"></span>';}
            
            $output .= '<span class="wpsbc-day-split-top wpsbc-day-split-top-'.$status.'"></span>';
            $output .= '<span class="wpsbc-day-split-bottom wpsbc-day-split-bottom-'.$status.'"></span>';    
            $output .= '<span class="wpsbc-day-split-day">'.$actday.'</span></li>';    
        }
        $output .= '</ul>';
    }

    //Now display the partial last week of the month (if there is one)
    if ($actday < $lastDay['mday']) {
        $output .= '<ul>';
        $actday++;
        if($showWeekNumbers == 'yes'){
            $output .= '<li class="wpsbc-week-number" title="'.__('Week').' '.date('W',mktime(0,0,0,$monthToShow,$actday+1,$yearToShow)).'">'.date('W',mktime(0,0,0,$monthToShow,$actday+1,$yearToShow)).'</li>';
        }
        
        for ($i = 0; $i < 7; $i++) {
            if ($actday <= $lastDay['mday']) {
            if(!empty($calendarData[$yearToShow][$monthToShow][$actday]))
                $status = $calendarData[$yearToShow][$monthToShow][$actday];
            else 
                $status = 'default';
            
            $dataTimestamp = mktime(0,0,0,$monthToShow,$actday,$yearToShow);        
            //handle past dates & tooltips
            $tooltip = false;    
            if($dataTimestamp + (60*60*24) < time()  && $calendarHistory != 1){
                if($calendarHistory == 2) $status = 'default'; //show default
                if($calendarHistory == 3) $status = 'wpsbc-grey-out-history'; //grey-out
            } else {
                if(!empty($calendarData[$yearToShow][$monthToShow]['description-' . $actday]) && in_array($showTooltip,array(2,3)))
                $tooltip = ' data-tooltip="'.htmlentities(wpsbc_replaceCustom($calendarData[$yearToShow][$monthToShow]['description-' . $actday])).'" data-tooltip-date="'.wpsbc_timeFormat($dataTimestamp).'"';
            }
            $today = ($dataTimestamp == mktime(0,0,0,date('n',current_time('timestamp')),date('j',current_time('timestamp')),date('Y',current_time('timestamp')))) ? ' wpsbc-today' : ''; 
            
            $output .= '<li'.$tooltip.' class="wpsbc-day'.$today.' wpsbc-day-'.$actday.' status-' . $status .  ' ">';
            
            if($tooltip && $showTooltip == 3) {$output .= '<span class="wpsbc-tooltip-corner"></span>';}
            
            $output .= '<span class="wpsbc-day-split-top wpsbc-day-split-top-'.$status.'"></span>';
            $output .= '<span class="wpsbc-day-split-bottom wpsbc-day-split-bottom-'.$status.'"></span>';    
            $output .= '<span class="wpsbc-day-split-day">'.$actday++.'</span></li>';    
            } else {
                $output .= '<li class="wpsbc-pad"><!-- --></li>';
            }
        }
        $output .= '</ul>';
    }
    $output .= '<div class="wpsbc-loading"><img alt="Loading" src="'.WPSBC_PATH.'/images/ajax-loader.gif" /></div></div>';
    return $output;
}