<?php 

if ( current_user_can('manage_options') )
{
	if(!(version_compare(PHP_VERSION, '5.2.0') >= 0))
	{
		wp_redirect(admin_url('admin.php?page=wp-booking-system-export&result=' . urlencode('PHP version not met minimum version is 5.2.0 or higher and you have: ' . PHP_VERSION) ));
	}


	if ( isset($_GET['download']) )
	{
		global $wpdb;

		$get_calendars      = @$wpdb->prepare('SELECT ' . $wpdb->prefix . 'sbc_calendars.* FROM ' . $wpdb->prefix . 'sbc_calendars;', null);

        $export             = array(
            'calendars'     => $wpdb->get_results( $get_calendars, ARRAY_A ),
            'options'       => array(
                'wpsbc_db_version'       => get_option('wpsbc_db_version'),
                'wpsbc-languages'        => get_option('wpsbc-languages'),
                'wpsbc-options'          => get_option('wpsbc-options'),
                'wpsbc-default-legend'   => get_option('wpsbc-default-legend'),
            )
        );

        $year 		= date('Y');
	    $month 		= date('m');
	    $day 		= date('d');

	    $filename 	= 'wpsbc-export-'.$year.'-'.$month.'-'.$day.'.wpsbc';


	    if ( is_writable( plugin_dir_path( __FILE__ ) ) )
	    {
	    	file_put_contents( $filename, json_encode( $export ) );
	    }
	    else
	    {
	    	wp_redirect(admin_url('admin.php?page=wp-simple-booking-calendar-export&code=401&result=' . urlencode('Could not generate export file reason: <strong>Permission Denied!</strong>') ));
	    	die();
	    }
		

	    header('Content-Type: application/json');
	    header('Content-Disposition: attachment; filename="'.$filename.'";');
	    header('Content-Length: ' . filesize($filename));
		readfile($filename);
	}

	die();
	
}
?>     